/* ============ */
/* tstpmtch.c	*/
/* ============ */
/* ==================================================================== */
/* 		    Main Program to Test CalcPermuteChiSq		*/
/* ==================================================================== */

#include <time.h>
#include <mconf.h>
#include <anlzpmtn.c>
void
main()
{
    double  ChiSqProb;

    PRMUT_DATA_STRU PermuteData;

    int     CellExpect, NumElements;
    while (main)
    {
	do
	{
	    GetInt("Enter No. Elements Per Permutation [3-7]: ",
		&NumElements);
	}
	while (NumElements < 3 || NumElements > 7);

	PermuteData.NumElements = NumElements;

	PermuteData.NumCategories = (int) fac(PermuteData.NumElements);

	do
	{
	    GetInt("Enter Expectation for Each Category [>= 5]: ",
		&CellExpect);
	}
	while (CellExpect < 5);

	PermuteData.CellExpectation = CellExpect;
	PermuteData.RandFun = rand;

	PermuteData.NumObs = (UINT) PermuteData.CellExpectation *
	    PermuteData.NumCategories;

	srand(1);
	srand((unsigned) time(NULL));

	CalcPermuteChiSq(&PermuteData);
	ChiSqProb = 100.0 *
	    chdtr(PermuteData.NumCategories - 1,
		  PermuteData.PrmutChiSqStat);

	printf("%6d  Number of Elements Per Permutation\n", NumElements);
	printf("%6d  Categories in This Test\n", PermuteData.NumCategories);
	printf("%6d  Expected Events Per Category\n", CellExpect);
	printf("%6u  Observations (Permutations) Will be Analyzed\n",
			PermuteData.NumObs);
	printf("%6lu  Random Numbers Will Be Generated\n\n",
			(ULONG) PermuteData.NumObs * NumElements);

	printf("Chi-Square Statistic = %f\n", PermuteData.PrmutChiSqStat);
	printf("Chi-Square Probability for %d Degrees of Freedom = %f\n",
			PermuteData.NumCategories - 1, ChiSqProb);
    }
}
